<?php
require_once '../config.php';
verificarLogin();

$security = new Security($pdo);
$id = $_GET['id'];

// Verificar CSRF
if (!isset($_GET['csrf_token']) || !$security->verifyCSRFToken($_GET['csrf_token'])) {
    die("Token CSRF inválido!");
}

try {
    // Registrar na auditoria antes de excluir
    $stmt = $pdo->prepare("INSERT INTO security_logs (usuario_id, acao, ip_address, user_agent) VALUES (?, ?, ?, ?)");
    $stmt->execute([$_SESSION['usuario_id'], 'excluir_cliente', $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
    
    $stmt = $pdo->prepare("DELETE FROM clientes WHERE id = ? AND usuario_id = ?");
    $stmt->execute([$id, $_SESSION['usuario_id']]);
    
    header("Location: clientes.php?sucesso=1");
    exit();
} catch (PDOException $e) {
    header("Location: clientes.php?erro=1");
    exit();
}
?>